import numpy as np
import pandas as pd
import os
import re

#import files
path=r'Global Steeplant capacity and production.csv'
df_Steelpro=pd.read_csv(path)

df_Steelpro.loc[df_Steelpro ['Classify-coke']=='without by-product recovery','Coke Emission']=df_Steelpro['coke output (kt)']*1.23 #coke without recovery, Source IPCC
df_Steelpro.loc[df_Steelpro ['Classify-coke']=='with by-product recovery','Coke Emission']=df_Steelpro['coke output (kt)']*0.51 #coke with recovery, Source IPCC

#CAL CO2 EMISSION FOR PROCESSING UNIT
df_Steelpro['Sinter Emission']=df_Steelpro['sinter output (kt)']*0.21 #sinter EF, Source IPCC
df_Steelpro['DRI Emission']=df_Steelpro['DRI output (kt)']*0.70 #sinter EF, Source IPCC
df_Steelpro['Pigiron Emission']=df_Steelpro['BF pig iron output (kt)']*1.43 #BF EF, Source IPCC
df_Steelpro.loc[df_Steelpro ['BOF output (kt)']!=0,'Pigiron Emission']=0 #BF-BOF 
df_Steelpro.loc[df_Steelpro ['OHF output (kt)']!=0,'Pigiron Emission']=0 #BF-BOF 

df_Steelpro.loc[df_Steelpro ['BOF output (kt)']!=0,'Coke Emission']=0 #COKE-BOF 
df_Steelpro.loc[df_Steelpro ['OHF output (kt)']!=0,'Coke Emission']=0 #COKE-OHF 

df_Steelpro['BOF Emission']=df_Steelpro['BOF output (kt)']*1.58 #BOF EF, Source IPCC
#df_Steelpro.loc[df_Steelpro ['total pig iron output (kt)']==0,'BOF Emission']=df_Steelpro['BOF output (kt)']*1.58 #BOF-BF EF, Source IPCC
df_Steelpro['EAF Emission']=df_Steelpro['EAF output (kt)']*0.18 #EAF EF, Source IPCC
df_Steelpro['OHF Emission']=df_Steelpro['OHF output (kt)']*1.72 #OHF EF, Source IPCC

#SUMMARIZE PROCESS CO2 EMISSION FOR PLANTS
df_Steelpro['Process CO2 Emissions-2019 (Mt)']=(df_Steelpro[['Coke Emission','Sinter Emission','DRI Emission','Pigiron Emission','BOF Emission','EAF Emission','OHF Emission']].sum(axis=1))/1000
df_Steelpro.replace([np.inf, -np.inf], np.nan, inplace=True) 
df_Steelpro['Process CO2 Emissions-2019 (Mt)'].fillna(0, inplace=True)

outpath=r'XXXX'
df_Steelpro.to_csv(outpath+r'\Global Steeplant Process CO2 emissions.csv')

